# Project
This project contains conversion tools for image compression and manipulation using dense skeletons.
With this, image compression with a compression ratio higher than JPEG can be achieved.
Our methods and techniques are presented in the thesis.

# Building
In this section we explain how to build and use our tools and thesis
## Software
First, descend to `shared/squash` and run `./autogen.sh`
Then, one can build both `imConvert` and `imShow`.
Both equally-named directories contain Makefiles which yields two executables named `skeletonify` and `show_skeleton`, respectively.
`skeletonify` accepts a path to a configuration file as parameter and outputs a `SIR` file.
`show_skeleton` accepts a path to a `SIR` file as parameter and shows a reconstruction of the image.

A configuration file with all its parameters may look like this:
```javascript
# input image. Must be PGM or PPM 
filename = ../examples/lena_gray_512.pgm
# Verbose output
outputLevel=v
# number of layers
num_layers = 20
# layer selection method, other allowed value is thresholding
layer_selection = peaks
# skeleton connected size threshold
sThreshold = 5
# Saliency treshold
ssThreshold = 2
# Island size threshold
siThreshold = 3
# Output file name
outputFile = ./lena512-bundled.sir
# external compression algorithm 
compression_method = zpaq
# perform overlap pruning?
overlap_pruning = false
# allowed radius difference before pruning
overlap_pruning_epsilon = .05
# encoding method
encoding = traditional
# perform bundling?
bundle = false
alpha = 1
epsilon = 5
```
More examples of configuration files are included in the `examples` folder.

This software was tested as working on Arch Linux 64-bit and has the following dependencies:
 * A C++ compiler -- tested with `GCC 6.3.1` and `clang 3.9.1`
 * `CUDA` -- tested with `CUDA 8`
 * `make 4.2.1`
 * `cmake 3.7.2`
 * `boost 1.63`
 * `ragel 6.9`
 * `vala 0.34`
 * An OpenGL distribution i.e. `GLUT 3.0.0` and `GLEW 2.0.0`

These tools can under Arch Linux be installed with:
`# pacman -S gcc cuda cmake boost ragel vala freeglut glew`

In another distribution like Ubuntu these ought to be satisfied by:
`# apt-get install gcc make cmake nvidia-cuda-dev libboost-all-dev freeglut3-dev libglew-dev ragel libvala-0.34-dev`
but this was not explicitly tested.

These packages are available to most Linux distributions using the package manager.
Other versions may also work but your mileage may vary.

# Thesis
It is necessary to have a recent edition of the TeXLive suite to compile the thesis.
It is also necessary to have PGF for TikZ available and minted for syntax highlighting
Under Arch Linux, these can be installed using the command
`# pacman -S texlive-most libpgf minted`

The easiest way to compile the LaTeX sources into a PDF file is by running the command
`$ latexmk -xelatex -shell-escape report.tex`
Which will yield a `report.pdf` file.